//=============================================================================
// OnslaughtAmplify.js
// ----------------------------------------------------------------------------
// (C)2025 kuroame koubou
// This software is released under the MIT License.
// http://opensource.org/licenses/mit-license.php
// ----------------------------------------------------------------------------
// Version
// 0.9.1 2025/2/2 初版
// ----------------------------------------------------------------------------
// [Blog]   : https://ci-en.net/creator/14684
// [Twitter]: https://twitter.com/kuroVelter9623
//=============================================================================

/*:
 * @plugindesc 系統連撃補正プラグイン
 * @target MZ
 * @author くろあめ
 *
 * @help
 * 特定のタグを持つスキルを、1ターン中に連続でヒットさせると
 * 同じタグを持つ後続のスキルの威力を増幅する機能を実装します。
 * 
 * アイテム、スキルのメモ欄に
 * <Onslaught:x,yy>と記載することで 
 * そのアイテム、スキルが命中した際に、同ターン中・同じ対象に対する
 * <Onslaught:x> を持つスキルの威力をyy%増幅させます。
 * 
 * 
 * 【設定例1】
 * <Onslaught:1,30> とメモ欄に記載されたスキルからダメージを受けた対象が
 * 同ターン中に、<Onslaught:1,20> とメモ欄に記載されたスキルからダメージを受けた場合
 * そのダメージは30%上昇します。
 * 
 * さらにその後、対象が同ターン中に
 * <Onslaught:1,15> とメモ欄に記載されたスキルからダメージを受けた場合
 * その威力は50%上昇します。
 * 
 * 
 * 【設定例2】 
 * すべての「剣技」スキルのメモ欄に <Onslaught:2,10> と記述しておくことで
 * 「剣技は同ターン中にヒットさせるごとに10%威力を増していく系統」とすることができます。
 * 
 * 
 * <Onslaught>メタタグは、メモ帳ひとつにつき1つの記載しか有効になりません
 * 複数の装備やステートなどに記載された分は、全て加味されます。 
 * 
 * このプラグインは、ターン制戦闘にのみ対応しています
 * タイムプログレス戦闘に導入すると、正常に動作しません。
 * 
 * 
 * 利用形態（商用、18禁利用等）について制限はありません
 * 作者への使用報告や、ReadMeなどへ作者・サイト名の記載も任意となります。
 * 
 * ただし、作者はこれらのプラグインについて
 * 基本的に一切のサポートを行いません
 * 何か問題が起きた時、ご自身で解決できる方のみご利用ください。
 */


(function() {

const _BattleManager_initMembers = BattleManager.initMembers;
BattleManager.initMembers = function() {
    //console.log("call initMembers");
    _BattleManager_initMembers.call(this);
    this.clearOnslaught();
};

const _BattleManager_startTurn = BattleManager.startTurn;
BattleManager.startTurn = function() {
    //console.log("call startTurn");
    _BattleManager_startTurn.call(this);
    this.clearOnslaught();
};

const _BattleManager_endTurn = BattleManager.endTurn;
BattleManager.endTurn = function() {
    //console.log("call endTurn");
    _BattleManager_endTurn.call(this);
    this.clearOnslaught();
};

const _BattleManager_endBattle = BattleManager.endBattle;
BattleManager.endBattle = function(result) {
    //console.log("call endBattle");
    this.clearOnslaught();
    _BattleManager_endBattle.apply(this, arguments);
};


// 戦闘参加全メンバーの系統連撃値初期化
BattleManager.clearOnslaught = function() {
    //console.log("call clearOnslaught");
    $gameParty.clearOnslaught();
    $gameTroop.clearOnslaught();
};



// 系統連撃値 初期化＆定義
const _Game_Battler_initMembers = Game_Battler.prototype.initMembers;
Game_Battler.prototype.initMembers = function() {
    _Game_Battler_initMembers.call(this);
    this.onslaught = [];
};

Game_Battler.prototype.clearOnslaught = function() {
    this.onslaught = [];
};

Game_Battler.prototype.getOnslaught = function(index) {

    if (this.onslaught[index] === undefined){
        this.onslaught[index] = 0;
    }
    return this.onslaught[index];
};

Game_Battler.prototype.getOnslaughtAmplify = function(index) {
    return 100 + this.getOnslaught(index);
};

Game_Battler.prototype.chargeOnslaught = function(index,plus) {
    if (this.onslaught[index] === undefined){
        this.onslaught[index] = 0;
    }
    this.onslaught[index] += plus;
};


Game_Party.prototype.clearOnslaught = function() {
    for (const actor of this.battleMembers()) {
        actor.clearOnslaught();
    }
};

Game_Troop.prototype.clearOnslaught = function() {
    for (const enemy of this.members()) {
        enemy.clearOnslaught();
    }
};



/* ダメージ計算関数の末尾で系統連撃補正を加味 */
const _Game_Action_makeDamageValue_onslaught = Game_Action.prototype.makeDamageValue;
Game_Action.prototype.makeDamageValue = function(target, critical){
    var value = _Game_Action_makeDamageValue_onslaught.apply(this, arguments);
    
    value = this.calcOnslaughtAmplify(value,target,this.item());
    
    return Math.round(value);
};

Game_Action.prototype.calcOnslaughtAmplify = function(value,target,item){
    
    //console.log("call calcOnslaughtAmplify");
    
    //var teststr = "";
    //console.log(teststr.concat(item.name," 連撃補正前ダメージ"));
    //console.log(teststr.concat(value));
    
    //console.log(target.onslaught);
    
    if (item && item.meta && item.meta.Onslaught) {
        var getMeta = item.meta.Onslaught.split(',');
        var amplify = target.getOnslaughtAmplify(getMeta[0]);
        
        //console.log(teststr.concat("系統連撃ID:",getMeta[0]));
        //console.log(teststr.concat("現在系統連撃値:",target.getOnslaught(getMeta[0])));
        //console.log(teststr.concat("系統連撃補正:",amplify));
        
        value = value * amplify / 100;
        
        //console.log(getMeta);
        
        target.chargeOnslaught(getMeta[0],Number(getMeta[1]));
    }
    
    //console.log(teststr.concat(item.name," 連撃補正後ダメージ"));
    //console.log(teststr.concat(value));
    
    return value;
};


})();